#include <iostream>
#include <vector>

using namespace std;

// Funkcija koja izracunava XOR dva niza
vector<int> calculateXOR(const vector<int>& P) {
    int N = P.size() - 1;
    vector<int> Q(N + 1);

    for (int i = 0; i <= N; i++) {
        Q[i] = P[i] ^ P[i + 1];
    }

    return Q;
}

int main() {
    int T;
    cin >> T;

    for (int t = 0; t < T; t++) {
        int N;
        cin >> N;

        vector<int> P(N + 1);
        for (int i = 0; i <= N; i++) {
            cin >> P[i];
        }

        // Izracunavanje XOR niza Q
        vector<int> Q = calculateXOR(P);

        // Izracunavanje vrednosti izraza X
        int X = 0;
        for (int i = 0; i <= N; i++) {
            X += P[i];
        }

        // Ispis rezultata
        cout << X << endl;
        for (int i = 0; i < N; i++) {
            cout << Q[i] << " ";
        }
        cout << endl;
    }

    return 0;
}